<%
//	Obtain context
//
ServletContext refreshCtx = getServletConfig().getServletContext();
String refreshTime = "";

//	Logout page gets a refresh tag, but ONLY if request is from a kiosk
//	or there is no auto-login cookie. 
//	Refreshing when there is an auto-login cookie would result
//	in going back to MyAlkindi every time!
//
//	If there is no login cookie, then the Logout page gets no refresh or
//	inactivity timeout.
//
if (requestContains(request, LOGOUT_PAGE)) {
	if (isKiosk(request) || getCookie(request, LOGIN_COOKIE) == null){
		refreshTime = refreshCtx.getInitParameter(LOGOUT_TIMEOUT_PARAM);
		%><meta http-equiv="refresh" content="<%=refreshTime%>; URL=index.jsp">
<%
	}
}
else {
	//	 Otherwise, obtain the timeout for this page.
	//
	refreshTime = refreshCtx.getInitParameter(WWW_TIMEOUT_PARAM);
	if (isKiosk(request)) 
		refreshTime = refreshCtx.getInitParameter(KIOSK_TIMEOUT_PARAM);

	//	Output a script to perform the inactivity timeout.
	//
%><script language="JavaScript" type="text/javascript">
<!--
var interval = <%=refreshTime%> * 1000;;
var isNetscape = (navigator.appName.indexOf("Netscape") != -1);

var timerID = 0;

function timedOut()
{
	location="<%=LOGOUT_PAGE%>";
}

function resetTimeout(evt)
{
	window.clearTimeout(timerID);
	timerID = window.setTimeout("timedOut()", interval);	
	if (isNetscape) return routeEvent(evt);
}

if (isNetscape) {
	captureEvents(Event.MOUSEMOVE | Event.KEYDOWN);
}
if (isNetscape) {
	onMouseMove=resetTimeout;
	onKeyDown=resetTimeout;
}
else {
	document.onmousemove = resetTimeout;
	document.onkeydown = resetTimeout;
}


timerID = window.setTimeout("timedOut()", interval);

//-->
</script><%
}%>
